#include <iostream>
#include <iomanip>
#include <fstream>
#include <string>
#include <time.h>
#include <vector>

#include "searcher.h"
#include "movegen.h"
#include "make.h"
#include "move.h"
#include "fen.h"
#include "log.h"

using namespace std;


void  cSearcher::go(uint depth)
{
	ASS(position_check(game,mat));

    if (depth == 0)
    {
        incrnodes();
		return;
    }

    gen_all_moves(game, mat, mlist, NULLMOVE);
    uint *list = mlist.p2list(game.getply());

    for(uint i = 0; i < mlist.getcount(game.getply()); ++i)
    {

     if (makemove(game,mat,his,list[i]))
     {
       takemove(game,mat,his);
       continue;
     }

    // cout<<"\nmove "<<printmove(list[i]);

     go(depth-1);
     takemove(game,mat,his);
    }

    return;
}


void   cSearcher::goroot(uint depth)
{
   if (depth == 0)  return;

   u64 oldnodes = 0;
   u64 cumnodes = 0;

   gen_all_moves(game, mat, mlist, NULLMOVE);
   uint *list = mlist.p2list(game.getply());
   int moves = 0;
   for(uint i = 0; i < mlist.getcount(game.getply()); ++i)
   {
     if (makemove(game,mat,his,list[i]))
     {
        takemove(game,mat,his);
        continue;
     }
     moves++;
     cout<<"\nmove "<<moves<<" "<<printmove(list[i]);
     cumnodes = getnodes();
     go(depth-1);
     takemove(game,mat,his);
     oldnodes = getnodes()-cumnodes;
     cout<<" "<<oldnodes;
   }
       return;
}

void cSearcher::perftsingle()
{
     resetdata();
     timer.start();
     cout<<"\n perft with depth "<<getstartdepth();
     goroot(param->iterdepth);
     timer.stop();
     cout<<"\n pnodes = "<<(getnodes());
     cout<<"\n time = "<<(timer.time_elapsed())<<"ms";
     if(timer.time_elapsed() < 1)
	 cout<<"\n NPS "<<((getnodes())/1)/1000<<"kns";
	 else
	 cout<<"\n NPS "<<((getnodes())/(timer.time_elapsed()))/1000<<"kns";

}

void cSearcher::perftnormal(uint depth)
{
    timer.setdepth(depth);
    perftsingle();
}

void cSearcher::perftfile()
{
    string position;
    string temp;
    string marker;
    string textnodes;
    uint targetnodes = 0;
    vector<int> results;
    vector<string> p;

    if(logger.islog())logger.file << "entered perftfile\n";


    ifstream file ("perftsuite.epd");

    uint depth = 0;
    cout<<"\n Enter depth >> ";
    cin>>depth;
    timer.setdepth(depth);
    cout<<"\n";

    if(logger.islog())logger.file << "depth "<<depth;

    switch(depth)
    {
        case 1: marker = "D1"; break;
        case 2: marker = "D2"; break;
        case 3: marker = "D3"; break;
        case 4: marker = "D4"; break;
        case 5: marker = "D5"; break;
        case 6: marker = "D6"; break;
        default: marker = "D4";break;
    }


    int pos = 0;
    int mark;
    string::iterator pline = temp.begin();

    if (file.is_open())
    {
      while (! file.eof() )
      {
       getline (file,position);
       if(position.length() < 2) break;
       temp = position;
       mark = temp.find(marker);
       temp.erase(0, mark+3);
       textnodes.clear();
       pline = temp.begin();
       while ( pline != temp.end() && *pline != ' ' )
       {
           textnodes+=*pline;
           *pline++;
       }

       targetnodes = strtouint(textnodes,0);

       temp = position;
       mark = temp.find(";");
       temp.erase(mark-1);

       pos++;

       cout<<"\n Testing Position "<<pos;
       cout<<temp;
       setepdposition(temp.c_str(),game,mat,his);
       p.push_back(temp);

       if(logger.islog())logger.file << "testing position "<<pos<<"n";

       //game.printboard();
       perftsingle();
       cout<<"\n\n Target nodes = "<<targetnodes;
       if(targetnodes != getnodes())
       {
           cout<<"\n   FAIL\n";
           results.push_back(0);
           if(logger.islog())logger.file << "FAIL\n";
       }
       else
       {
           results.push_back(1);
           if(logger.islog())logger.file << "PASS\n";
       }
      }
    file.close();
    }
    else
    cout<<"\n file 'perftsuite.epd' not found!";
    if(logger.islog())logger.file<<" file 'perftsuite.epd' not found!\n";

    cout<<"\n "<<pos<<" positions in total";
    for(uint i = 0; i < results.size(); ++i)
    {
        cout<<"\n position "<<i+1;

        if(results[i] == 0)
        {
            cout<<" FAILED ";
            cout<<p[i];
        }
        else
        {
            cout<<" PASSED";
        }
    }

    cout<<endl;

    return;
}

